CREATE DATABASE IF NOT EXISTS finance_db;
USE finance_db;

CREATE TABLE IF NOT EXISTS cashflow (
    id INT AUTO_INCREMENT PRIMARY KEY,
    date DATE,
    description VARCHAR(255),
    amount DECIMAL(10,2),
    type ENUM('income', 'expense')
);

CREATE TABLE IF NOT EXISTS budget (
    id INT AUTO_INCREMENT PRIMARY KEY,
    category VARCHAR(100),
    allocated_amount DECIMAL(10,2),
    spent_amount DECIMAL(10,2)
);

CREATE TABLE IF NOT EXISTS loans (
    id INT AUTO_INCREMENT PRIMARY KEY,
    lender VARCHAR(255),
    amount DECIMAL(10,2),
    due_date DATE
);

CREATE TABLE IF NOT EXISTS bank_accounts (
    id INT AUTO_INCREMENT PRIMARY KEY,
    bank_name VARCHAR(255),
    account_number VARCHAR(100),
    balance DECIMAL(10,2)
);

CREATE TABLE IF NOT EXISTS investments (
    id INT AUTO_INCREMENT PRIMARY KEY,
    type VARCHAR(100),
    amount DECIMAL(10,2),
    invested_on DATE
);
